/*
 * MATLAB Compiler: 3.0
 * Date: Mon Nov 03 13:00:57 2003
 * Arguments: "-B" "macro_default" "-O" "all" "-O" "fold_scalar_mxarrays:on"
 * "-O" "fold_non_scalar_mxarrays:on" "-O" "optimize_integer_for_loops:on" "-O"
 * "array_indexing:on" "-O" "optimize_conditionals:on" "-m" "-W" "main" "-L"
 * "C" "-t" "-T" "link:exe" "-h" "libmmfile.mlib" "DancingMonkeys" 
 */
#include "buttap.h"
#include "libmatlbm.h"
static mxArray * _mxarray0_;
static mxArray * _mxarray1_;
static mxArray * _mxarray2_;
static mxArray * _mxarray3_;
static mxArray * _mxarray4_;
static mxArray * _mxarray5_;
static mxArray * _mxarray6_;

void InitializeModule_buttap(void) {
    _mxarray0_ = mclInitializeDoubleVector(0, 0, (double *)NULL);
    _mxarray1_ = mclInitializeComplex(0.0, 1.0);
    _mxarray2_ = mclInitializeDouble(3.141592653589793);
    _mxarray3_ = mclInitializeDouble(1.0);
    _mxarray4_ = mclInitializeDouble(2.0);
    _mxarray5_ = mclInitializeDouble(1.5707963267948966);
    _mxarray6_ = mclInitializeDouble(-1.0);
}

void TerminateModule_buttap(void) {
    mxDestroyArray(_mxarray6_);
    mxDestroyArray(_mxarray5_);
    mxDestroyArray(_mxarray4_);
    mxDestroyArray(_mxarray3_);
    mxDestroyArray(_mxarray2_);
    mxDestroyArray(_mxarray1_);
    mxDestroyArray(_mxarray0_);
}

static mxArray * Mbuttap(mxArray * * p,
                         mxArray * * k,
                         int nargout_,
                         mxArray * n);

_mexLocalFunctionTable _local_function_table_buttap
  = { 0, (mexFunctionTableEntry *)NULL };

/*
 * The function "mlfButtap" contains the normal interface for the "buttap"
 * M-function from file "c:\matlab65\toolbox\signal\signal\buttap.m" (lines
 * 1-25). This function processes any input arguments and passes them to the
 * implementation version of the function, appearing above.
 */
mxArray * mlfButtap(mxArray * * p, mxArray * * k, mxArray * n) {
    int nargout = 1;
    mxArray * z = NULL;
    mxArray * p__ = NULL;
    mxArray * k__ = NULL;
    mlfEnterNewContext(2, 1, p, k, n);
    if (p != NULL) {
        ++nargout;
    }
    if (k != NULL) {
        ++nargout;
    }
    z = Mbuttap(&p__, &k__, nargout, n);
    mlfRestorePreviousContext(2, 1, p, k, n);
    if (p != NULL) {
        mclCopyOutputArg(p, p__);
    } else {
        mxDestroyArray(p__);
    }
    if (k != NULL) {
        mclCopyOutputArg(k, k__);
    } else {
        mxDestroyArray(k__);
    }
    return mlfReturnValue(z);
}

/*
 * The function "mlxButtap" contains the feval interface for the "buttap"
 * M-function from file "c:\matlab65\toolbox\signal\signal\buttap.m" (lines
 * 1-25). The feval function calls the implementation version of buttap through
 * this function. This function processes any input arguments and passes them
 * to the implementation version of the function, appearing above.
 */
void mlxButtap(int nlhs, mxArray * plhs[], int nrhs, mxArray * prhs[]) {
    mxArray * mprhs[1];
    mxArray * mplhs[3];
    int i;
    if (nlhs > 3) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: buttap Line: 1 Column: "
            "1 The function \"buttap\" was called with mor"
            "e than the declared number of outputs (3)."),
          NULL);
    }
    if (nrhs > 1) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: buttap Line: 1 Column: "
            "1 The function \"buttap\" was called with mor"
            "e than the declared number of inputs (1)."),
          NULL);
    }
    for (i = 0; i < 3; ++i) {
        mplhs[i] = NULL;
    }
    for (i = 0; i < 1 && i < nrhs; ++i) {
        mprhs[i] = prhs[i];
    }
    for (; i < 1; ++i) {
        mprhs[i] = NULL;
    }
    mlfEnterNewContext(0, 1, mprhs[0]);
    mplhs[0] = Mbuttap(&mplhs[1], &mplhs[2], nlhs, mprhs[0]);
    mlfRestorePreviousContext(0, 1, mprhs[0]);
    plhs[0] = mplhs[0];
    for (i = 1; i < 3 && i < nlhs; ++i) {
        plhs[i] = mplhs[i];
    }
    for (; i < 3; ++i) {
        mxDestroyArray(mplhs[i]);
    }
}

/*
 * The function "Mbuttap" is the implementation version of the "buttap"
 * M-function from file "c:\matlab65\toolbox\signal\signal\buttap.m" (lines
 * 1-25). It contains the actual compiled code for that M-function. It is a
 * static function and must only be called from one of the interface functions,
 * appearing below.
 */
/*
 * function [z,p,k] = buttap(n)
 */
static mxArray * Mbuttap(mxArray * * p,
                         mxArray * * k,
                         int nargout_,
                         mxArray * n) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(&_local_function_table_buttap);
    mxArray * z = NULL;
    mclCopyArray(&n);
    /*
     * %BUTTAP Butterworth analog lowpass filter prototype.
     * %   [Z,P,K] = BUTTAP(N) returns the zeros, poles, and gain
     * %   for an N-th order normalized prototype Butterworth analog
     * %   lowpass filter.  The resulting filter has N poles around
     * %   the unit circle in the left half plane, and no zeros.
     * %
     * %   See also BUTTER, CHEB1AP, CHEB2AP, ELLIPAP.
     * 
     * %   Author(s): J.N. Little and J.O. Smith, 1-14-87
     * %   	   L. Shure, 1-13-88, revised
     * %   Copyright 1988-2002 The MathWorks, Inc.
     * %   $Revision: 1.6 $  $Date: 2002/03/28 17:27:09 $
     * 
     * % Poles are on the unit circle in the left-half plane.
     * z = [];
     */
    mlfAssign(&z, _mxarray0_);
    /*
     * p = exp(i*(pi*(1:2:n-1)/(2*n) + pi/2));
     */
    mlfAssign(
      p,
      mlfExp(
        mclMtimes(
          _mxarray1_,
          mclPlus(
            mclMrdivide(
              mclMtimes(
                _mxarray2_,
                mlfColon(
                  _mxarray3_, _mxarray4_, mclMinus(mclVa(n, "n"), _mxarray3_))),
              mclMtimes(_mxarray4_, mclVa(n, "n"))),
            _mxarray5_))));
    /*
     * p = [p; conj(p)];
     */
    mlfAssign(p, mlfVertcat(mclVv(*p, "p"), mlfConj(mclVv(*p, "p")), NULL));
    /*
     * p = p(:);
     */
    mlfAssign(p, mclArrayRef1(mclVv(*p, "p"), mlfCreateColonIndex()));
    /*
     * if rem(n,2)==1   % n is odd
     */
    if (mclEqBool(mlfRem(mclVa(n, "n"), _mxarray4_), _mxarray3_)) {
        /*
         * p = [p; -1];
         */
        mlfAssign(p, mlfVertcat(mclVv(*p, "p"), _mxarray6_, NULL));
    /*
     * end
     */
    }
    /*
     * k = real(prod(-p));
     */
    mlfAssign(k, mlfReal(mlfProd(mclUminus(mclVv(*p, "p")), NULL)));
    mclValidateOutput(z, 1, nargout_, "z", "buttap");
    mclValidateOutput(*p, 2, nargout_, "p", "buttap");
    mclValidateOutput(*k, 3, nargout_, "k", "buttap");
    mxDestroyArray(n);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    return z;
    /*
     * 
     */
}
